//---------------------------------------------------------------------------------------------
// Torque Game Builder
// Copyright (C) 
// yard sale junkie 1.0.3
//---------------------------------------------------------------------------------------------

/// Player Initialization Procedure
/// 
function onStart()
{   
}

function onExit()
{
}

//---------------------------------------------------------------------------------------------
// Load the paths we need access to
//---------------------------------------------------------------------------------------------
function loadPath( %path )
{
   setModPaths( getModPaths() @ ";" @ %path );
   exec(%path @ "/main.cs");

}

//---------------------------------------------
// Do some bootstrap voodoo to get the game to 
// the initializeProject phase of loading and 
// pass off to the user
//---------------------------------------------

// Output a console log
setLogMode(0);

loadPath( "common" );

loadPath( "game" );

onStart();

// Initialized
echo("\nTorque Game Builder (" @ getT2DVersion() @ ") initialized...");

if( !isFunction( "initializeProject" ) || !isFunction( "_initializeProject" ) )
{
   messageBox( "Game Startup Error", "'initializeProject' function could not be found." @
               "\nThis could indicate a bad or corrupt common directory for your game." @
               "\n\nThe Game will now shutdown because it cannot properly function", "Ok", "MIStop" );
   quit();
}





   $gameName = "Yard Sale Junkie";
   SetCanvasTitle($gameName);

   //toggleFullScreen();
   //###################################################################################
    //##################################################################################
    //##################################################################################
   //####################     load gui files  add by eyal        #######################
   
  
   exec("game/gameScripts/gui_v64.cs");
   exec("game/gui/mainMenuGui_v62.gui");
   exec("game/gui/distSplashGui.gui");
   exec("game/gui/splash_v62.gui");
   exec("game/gui/gameLoadingGui_v62.gui");
   
   
   Canvas.schedule(10,toggleFullScreen);
   
   Canvas.schedule(500,setContent,distSplashGui);
   Canvas.schedule(4500,setContent,splashGui);
   Canvas.schedule(5500,pushDialog,gameLoadingGui);
   Canvas.schedule(8000,setContent,mainMenuGui);
   Canvas.schedule(6000,"startProject");
   //####################          end of added content         ########################

function Canvas::toggleFullScreen(%this)
{
      toggleFullScreen();
}

function Canvas::startProject(%this)
{
   echo("####################    start project   #######################");
   _initializeProject();
   // Startup the project
   initializeProject();
}


